*=============================================================================
* File      : TreeDemo.gms
* Author    : Wietse Dol (w.dol@wur.nl)
* Version   : 1.0
* Date      : 20-Sep-10 10:26:04
* Changed   : 25-Aug-11 12:23:30
* Changed by: Wietse Dol (W.Dol@wur.nl)
* Remarks   :
$ontext
   This is an example how to use a tree structure of a set and calculate and check
   the data. The procedure PCaggregate.gms does four things:
   1. when a node in the data consists of a zero, the children of the node are aggregated
   2. a parameter is created by aggregating the children for every node (starting from the lowest level)
   3. a parameter is created that shows the differences between the parameters in step 1 and 2.
   4. a parameter is created that contains original/aggregated/missing and differences data

See also Example 16 in MetaBase for a large example with COMEXT data

$offtext
*=============================================================================
*_General settings and initialization
* Read the Gtree documentation for these special GTREECONTROL tags
*! <%GTREECONTROL JUMPLIST "@filenamenoext@.lst",0,0,"","GAMS LST file" %>
*! <%GTREECONTROL JUMPLIST "ElementTree.exe",0,0,"@pathname@TreeElements.tree","GAMS tree editor for elements" %>
*! <%GTREECONTROL JUMPLIST "iodata.gdx",0,0,"treedemo.gref","View results"%>
*! <%GTREECONTROL JUMPLIST "DataSelector.exe",0,0,"''@pathname@iodata.gdx'' Full_IOdata_TreeElements treedemo.gref /nometabase","DataSelector for Full IOdata" %>
*! <%GTREECONTROL JUMPLIST "@pathname@..\..\Using classifications in GAMS.doc",0,0,"","Using Classifications in GAMS"%>

*Progress display
$setGlobal WLOG no
*switch to yes if you want to use wlog
*switch to no  if you do not want to use wlog

*_ The commands and settings
$include settings.gms

*_ end of line comments are defined after
$eolcom //
*=============================================================================
*! EXAMPLE CODE FOR THE AGGREGATE FUNCTION
*=============================================================================
*_Declarations of user sets

set TreeElements
/
"Chapter1"
   "Section1"
      "SubSection1.1"
         "SubSubSection1.1.1"
         "SubSubSection1.1.2"
      "SubSection1.2"
   "Section2"
      "SubSection2.1"
"Chapter2"
   "Section3"
"Chapter3"
/;

*a Parent Child entry consists of three elements
*1. the level of the tree (starting with level1, i.e. the depth of the node)
*2. the child element
*3. the parent element
*Note that a root element the child element is equal to the parent
set PC_TreeElements(PClevels,TreeElements,TreeElements)
/
"level1"."Chapter1"."Chapter1"
"level2"."Section1"."Chapter1"
"level3"."SubSection1.1"."Section1"
"level4"."SubSubSection1.1.1"."SubSection1.1"
"level4"."SubSubSection1.1.2"."SubSection1.1"
"level3"."SubSection1.2"."Section1"
"level2"."Section2"."Chapter1"
"level3"."SubSection2.1"."Section2"
"level1"."Chapter2"."Chapter2"
"level2"."Section3"."Chapter2"
"level1"."Chapter3"."Chapter3"
/;

*$ontext
*! You can use the GAMStool ElementTree.exe (see also the JumpList) to create a tree with Elements and
*! write the GAMS code like this:
set TreeElements
/
$include "TreeElements.tree"
/;

parameter PC_TreeElements(PClevels,TreeElements,TreeElements)
/
$include "TreeElements.PC"
/;
*$offtext

*_Declaration of data
parameter IOData(TreeElements)
/
   "Chapter1"                  100
*    "Section1"                   70             //Missing value
        "SubSection1.1"              30
           "SubSubSection1.1.1"         20
           "SubSubSection1.1.2"         20
        "SubSection1.2"              40
     "Section2"                   30
           "SubSection2.1"              30
  "Chapter2"                  200
     "Section3"                  100
  "Chapter3"                  300
/;


*=============================================================================
*!Example 1:

%RunDisplay% "Example1: basic Aggregation"
%Aggregate% IOData ( TreeElements )

*%Aggregate% needs 4, 5 or 6 additional parameters
*1: Parameter
*2: Pre-domain
*3: Classification, i.e. over this classification the aggregation takes place
*4: Post-domain
*5: Parent Child tuple (optional)
*6: Text that is added before the new created parameters (optional, allowed when %5 is Parent Child tuple)

*_ the code above creates 3 parameters:
*-  Aggregated_IOdata_TreeElements(TreeElements)
*-  Full_IOdata_TreeElements(TreeElements,AggregateType)
*-  Difference_IOdata_TreeElements(TreeElements,AggregateType)

*=============================================================================
*!Example 2:
%RunDisplay% "Example2: Creating your own tree"
set Rules(PClevels,TreeElements,TreeElements)
/
 "level1"."Chapter1"."Chapter1"
 "level2"."Chapter2"."Chapter1"
 "level2"."Chapter3"."Chapter1"
/;
%Aggregate% IOData ( TreeElements ) Rules Rules_
*=============================================================================
*!Example 3:
%RunDisplay% "Example3: Tree and weights"
parameter Weight(PClevels,TreeElements,TreeElements)
/
 "level1"."Chapter1"."Chapter1"     1
 "level2"."Chapter2"."Chapter1"     0.25
 "level2"."Chapter3"."Chapter1"     0.25
/;
%Aggregate% IOData ( TreeElements ) Weight Weight_
*=============================================================================
*!Example 4:
%RunDisplay% "Example4: multidimensional data"
set Years/2000*2010/;

table IODataYears(TreeElements,Years)
                                   2000   2005  2010
  "Chapter1"                        100    110   120
     "Section1"                             90   100
        "SubSection1.1"              30     40    60
           "SubSubSection1.1.1"      10     20    30
           "SubSubSection1.1.2"      20     25    30
        "SubSection1.2"              40     50    40
     "Section2"                      30     20    40
           "SubSection2.1"           30     20    35
  "Chapter2"                        200    110   120
     "Section3"                     100    110   120
  "Chapter3"                        300    200   210

%Aggregate% IODataYears ( TreeElements ,Years)
*=============================================================================
*!Example 5:
parameter IOData2(TreeElements)
/
  "Chapter1"                  100
     "Section1"                   70
        "SubSection1.1"              30
           "SubSubSection1.1.1"          0      //no data for this node
           "SubSubSection1.1.2"          0      //no data for this node
        "SubSection1.2"              40
     "Section2"                   30
           "SubSection2.1"              30
  "Chapter2"                  200
     "Section3"                  100
  "Chapter3"                  300
/;

CheckEmptyChildren=1; //default: Check if all children are zero. If this is the case and the node has a value this value is used.
%RunDisplay% "Example5: basic Aggregation and CheckEmptyChildren"
%Aggregate% IOData2 ( TreeElements ) PC_TreeElements Check_

CheckEmptyChildren=0; //always aggregate the children to get the node value (even when all children are zero)
%RunDisplay% "Example5: basic Aggregation and CheckEmptyChildren"
%Aggregate% IOData2 ( TreeElements ) PC_TreeElements NOCheck_

set CheckChildren/'Check Children','No Check Children','Difference'/;
parameter CheckMethods(TreeElements,CheckChildren) 'Difference between the CheckEmptyChildren methods';
CheckMethods(TreeElements,'Check Children')   = Check_Aggregated_IOData2_TreeElements(TreeElements);
CheckMethods(TreeElements,'No Check Children')= NOCheck_Aggregated_IOData2_TreeElements(TreeElements);
CheckMethods(TreeElements,'Difference')       = Check_Aggregated_IOData2_TreeElements(TreeElements)-NOCheck_Aggregated_IOData2_TreeElements(TreeElements);
*=============================================================================
*!Example 6:
*Get Section1 and all its children and write the Parent Child tree to the Section1.pc file
*i.e. the set TreeElements_childs contains the elements and PC_TreeElements_childs contains the tree information (to be used for e.g. the Aggregate function)
%GetAllChilds% TreeElements PC_TreeElements "Section1" add
display PC_TreeElements_childs;

*there are two ways to write a .PC file:
*1. using the CreatePC function specifying the PC tuple you want to write and the set that is used for element descriptions
%CreatePC% "Section1.pc" PC_TreeElements_childs TreeElements

*2. use the CreatePCTREE function to create a .PC and .Tree file
%CreatePCTREE% "Section1B.pc" PC_TreeElements_childs TreeElements
*=============================================================================
*!Output
%RunDisplay% "Saving GDX"
execute_unload "IOdata.gdx",
  Aggregated_IOdata_TreeElements
  Difference_IOdata_TreeElements
  Full_IOdata_TreeElements
  Rules_Aggregated_IOdata_TreeElements
  Rules_Difference_IOdata_TreeElements
  Rules_Full_IOdata_TreeElements
  Weight_Aggregated_IOdata_TreeElements
  Weight_Difference_IOdata_TreeElements
  Weight_Full_IOdata_TreeElements
  Aggregated_IODataYears_TreeElements
  Difference_IODataYears_TreeElements
  Full_IODataYears_TreeElements
  CheckMethods
;
*=============================================================================
%rundisplay% "Finished! Read the LST file or inspect the GDX file!"
*============================   End Of File   ================================