*=============================================================================
*!Locked by : Wietse Dol (W.Dol@wur.nl)
*!Lock date : 26-Oct-10 11:03:41
* File      : Tree.gms
* Author    : Wietse Dol (w.dol@wur.nl)
* Version   : 1.0
* Date      : 08-Oct-10 09:49:37
* Changed   : 08-Feb-11 11:35:29
* Changed by: Wietse Dol (W.Dol@wur.nl)
* Remarks   :
$ontext

Here we have GAMS functions that can be used to work on SET trees:

GetChild                Get all children of a given element
GetParent               Get the parent(s) of a given element
GetAllChilds            Get children and its children of a given element
GetAllParents           Get parent and its parents of a given element
GetRoot                 Get all root elements
GetLevel                Get all elements at a certain level (i.e. level 1 is equal to GetRoot)
GetLevelCount           Get the number of elements at every level
GetChildrenWithLevel    Get elements that are children (of children) of a given element and are at a certain level
GetLevelElement         Show the level(s) of a given element
DefineSetsandParameters Define all Sets and Parameters needed for the tree routines (i.e. needed if you use loops)

Method                 |  Arguments                             | Output
-----------------------|----------------------------------------|-----------------------------------------
GetChild               |  SetName PC_SetName ElementName        | set %SetName%_childs
GetParent              |  SetName PC_SetName ElementName        | set %SetName%_parents
GetAllChilds           |  SetName PC_SetName ElementName        | set %SetName%_childs
GetAllParents          |  SetName PC_SetName ElementName        | set %SetName%_parents
GetRoot                |  SetName PC_SetName                    | set %SetName%_root
GetLevel               |  SetName PC_SetName Level              | set %SetName%_level%Level%
GetLevelCount          |  SetName PC_SetName                    | parameter CurLevelCount
GetChildrenWithLevel   |  SetName PC_SetName ElementName Level  | set %SetName%_%ElementName%_%Level%
GetLevelElement        |  SetName PC_SetName ElementName        | set %SetName%_%ElementName%
DefineSetsandParameters|  SetName PC_SetName                    | all parameters and sets needed for routines

Examples:
Command                                          |   Output
-------------------------------------------------|-----------------------------
%GetChild%              NUTS PC_NUTS NL000000    |   set NUTS_childs(NUTS)
%GetParent%             NUTS PC_NUTS NL110000    |   set NUTS_parents(NUTS)
%GetAllChilds%          NUTS PC_NUTS NL000000    |   set NUTS_childs(NUTS)
%GetAllParents%         NUTS PC_NUTS NL110000    |   set NUTS_parents(NUTS)
%GetRoot%               NUTS PC_NUTS             |   set NUTS_root(NUTS)
%GetLevel%              NUTS PC_NUTS 1           |   set NUTS_level1(NUTS)
%GetLevelCount%         NUTS PC_NUTS             |   parameter CurLevelCount(PClevels)
%GetLevelElement%       NUTS PC_NUTS NL000000    |   set NUTS_NL000000(PClevels)
%GetChildrenWithLevel%  NUTS PC_NUTS NL000000 2  |   set NUTS_NL000000_2(NUTS)

Tree.gms Uses: PCaggregate.gms and PClevels.gms
$offtext
*=============================================================================
$if "%1"=="" $exit
*=============================================================================
$goto %1

$include PCaggregate.gms
$exit;
*=============================================================================
*? Get all children of a node
$label GetChild
$if "%2"=="" $goto error
$if "%3"=="" $goto error
%display% "Get Children for %3"

$setlocal  CheckSet %2
$setlocal  PCset    %3
$setlocal  Child    %4

$if not defined %PCset%_Childs set %PCset%_Childs(PClevels,%CheckSet%,%CheckSet%);
;
%PCset%_Childs(PClevels,%CheckSet%,%CheckSet%)=no;
%PCset%_Childs(PClevels,%CheckSet%,%CheckSet%)$%PCset%(PClevels,%CheckSet%,"%Child%")=yes;
%PCset%_Childs(PClevels,"%Child%","%Child%")=no;

$if not defined %CheckSet%_Childs  set %CheckSet%_Childs(%CheckSet%);
option %CheckSet%_Childs < %PCset%_Childs;

$exit
*=============================================================================
*? Get the parent of a node
$label GetParent
$if "%2"=="" $goto error
$if "%3"=="" $goto error
%display% "Get Parent for %3"

$setlocal  CheckSet %2
$setlocal  PCset    %3
$setlocal  Parent   %4

$if not defined %PCset%_Parents  set %PCset%_Parents(PClevels,%CheckSet%,%CheckSet%);
%PCset%_Parents(PClevels,%CheckSet%,%CheckSet%)=no;
%PCset%_Parents(PClevels,%CheckSet%,%CheckSet%)$%PCset%(PClevels,"%Parent%",%CheckSet%)=yes;
%PCset%_Parents(PClevels,"%Parent%","%Parent%")=no;

$if not defined %CheckSet%_Parents  set %CheckSet%_Parents(%CheckSet%);
option %CheckSet%_Parents < %PCset%_Parents;
$exit

*=============================================================================
*? Get all children and their children of a node (complete tree below selected node)
$label GetAllChilds
$setlocal  CheckSet %2
$setlocal  PCset    %3
$setlocal  Child    %4
$setlocal  AddNode  %5
$if "%5"=="" $setlocal  AddNode  no

$onrecurse
%GetChild% %CheckSet% %PCset% %Child%


$if not defined %CheckSet%_StartLevel scalar %CheckSet%_StartLevel;
%CheckSet%_StartLevel=0;

option CurLevelCount < %PCset%;

$if not defined P_PClevels alias(PClevels,P_PClevels);

loop(PClevels$(CurLevelCount(PClevels)>0),
%CheckSet%_StartLevel$(%CheckSet%_StartLevel=0)=ord(PClevels);

%CheckSet%_Childs(%CheckSet%)=yes$%CheckSet%_Childs(%CheckSet%) or
                                 sum((%CheckSet%_Childs,P_PClevels)$(ord(P_PClevels)=Card(PClevels)-(ord(PClevels)-%CheckSet%_StartLevel)),%PCset%(P_PClevels,%CheckSet%,%CheckSet%_Childs));
);

$ifi not "%AddNode%"=="no" %CheckSet%_Childs("%Child%")=yes;

%PCset%_Childs(PClevels,%CheckSet%_Childs,%CheckSet%_Childs)=no;

*--------------------------------------------------------------------------------
$if not defined %CheckSet%_ChildLevels  set %CheckSet%_ChildLevels(PClevels,%CheckSet%);
%CheckSet%_ChildLevels(PClevels,%CheckSet%)=0;

option CurLevelCount < %PCset%;
$if not defined  %CheckSet%_elements set %CheckSet%_elements(%CheckSet%);
$if not defined  %CheckSet%_dummy set %CheckSet%_dummy(PClevels);
%CheckSet%_elements(%CheckSet%)=no;
%CheckSet%_elements(%CheckSet%_Childs)=yes;
%CheckSet%_elements("%Child%")=yes;

loop(%CheckSet%_Childs,

%CheckSet%_dummy(PClevels)=no;
loop(PClevels$(CurLevelCount(PClevels)>0),
%CheckSet%_dummy(PClevels)=yes$sum(%CheckSet%_elements,%PCset%(PClevels,%CheckSet%_Childs,%CheckSet%_elements));
);

%CheckSet%_ChildLevels(PClevels,%CheckSet%_childs)$%CheckSet%_dummy(PClevels)=yes;

);
*--------------------------------------------------------------------------------
*create new tree set, i.e. PC relationship
$if not defined P_%CheckSet%_Childs alias(P_%CheckSet%_Childs,%CheckSet%_Childs);

$if not defined %PCset%_ChildsDummy set %PCset%_ChildsDummy(PClevels,%CheckSet%,%CheckSet%);
%PCset%_ChildsDummy(PClevels,%CheckSet%_Childs,P_%CheckSet%_Childs)=yes$%PCset%(PClevels,%CheckSet%_Childs,P_%CheckSet%_Childs);


option CurLevelCount < %PCset%_ChildsDummy;

$if not defined %CheckSet%_StartLevel scalar %CheckSet%_StartLevel;
%CheckSet%_StartLevel=0;

$if not defined %CheckSet%_EndLevel scalar %CheckSet%_EndLevel;
%CheckSet%_EndLevel=256;

loop(PClevels$(CurLevelCount(PClevels)>0),
%CheckSet%_StartLevel$(%CheckSet%_StartLevel=0)=ord(PClevels);
%CheckSet%_EndLevel$((%CheckSet%_StartLevel<>0) and (CurLevelCount(PClevels)>0))=ord(PClevels);
);

$if not defined ChildCorrect scalar ChildCorrect;
ChildCorrect=sum(pclevels,1$%PCset%_ChildsDummy(PClevels,"%Child%","%Child%"));

$ifthen not %AddNode%=="no"
%PCset%_ChildsDummy(PClevels,"%Child%","%Child%")$((ChildCorrect=0) and (ord(PClevels)=%CheckSet%_EndLevel+1))=yes;
$else
%PCset%_ChildsDummy(PClevels,P_%CheckSet%_Childs,P_%CheckSet%_Childs)$((ord(PClevels)=%CheckSet%_EndLevel+1) and %CheckSet%_ChildLevels(PClevels,P_%CheckSet%_Childs))=yes;
$endif
ChildCorrect=256-%CheckSet%_EndLevel-1;

%PCset%_Childs(PClevels,P_%CheckSet%_Childs,%CheckSet%_Childs)=no;

loop(PClevels$(ChildCorrect>0),
%PCset%_Childs(PClevels+ChildCorrect,P_%CheckSet%_Childs,%CheckSet%_Childs)$
  (%PCset%_ChildsDummy(PClevels,P_%CheckSet%_Childs,%CheckSet%_Childs))=yes;
);

loop(PClevels$(ChildCorrect<=0),
%PCset%_Childs(PClevels,P_%CheckSet%_Childs,%CheckSet%_Childs)$
  (%PCset%_ChildsDummy(PClevels,P_%CheckSet%_Childs,%CheckSet%_Childs))=yes;
);

$offrecurse
$exit;
*=============================================================================
*? Get the parent and their parents of a node
$label GetAllParents
$setlocal  CheckSet %2
$setlocal  PCset    %3
$setlocal  Parent   %4
$setlocal  AddNode  %5
$if "%5"=="" $setlocal  AddNode  no
$onrecurse

$if not defined %PCset%_Parents  set %PCset%_Parents(PClevels,%CheckSet%,%CheckSet%);
%GetParent% %CheckSet% %PCset% %Parent%

option CurLevelCount < %PCset%;

loop(PClevels$(CurLevelCount(PClevels)>0),
%CheckSet%_Parents(%CheckSet%)=yes$%CheckSet%_Parents(%CheckSet%) or
                                  sum(%CheckSet%_Parents,%PCset%(PClevels,%CheckSet%_Parents,%CheckSet%));
);

$ifi not "%AddNode%"=="no" %CheckSet%_Parents("%Parent%")=yes;

%PCset%_Parents(PClevels,%CheckSet%_Parents,%CheckSet%_Parents)=no;
*--------------------------------------------------------------------------------
$if not defined %CheckSet%_ParentLevels  set %CheckSet%_ParentLevels(PClevels,%CheckSet%);
%CheckSet%_ParentLevels(PClevels,%CheckSet%)=0;

option CurLevelCount < %PCset%;
$if not defined  %CheckSet%_elements set %CheckSet%_elements(%CheckSet%);
$if not defined  %CheckSet%_dummy set %CheckSet%_dummy(PClevels);
%CheckSet%_elements(%CheckSet%)=no;
%CheckSet%_elements(%CheckSet%_Parents)=yes;
%CheckSet%_elements("%Parent%")=yes;

loop(%CheckSet%_Parents,

%CheckSet%_dummy(PClevels)=no;
loop(PClevels$(CurLevelCount(PClevels)>0),
%CheckSet%_dummy(PClevels)=yes$sum(%CheckSet%_elements,%PCset%(PClevels,%CheckSet%_Parents,%CheckSet%_elements));
);

%CheckSet%_ParentLevels(PClevels,%CheckSet%_Parents)$%CheckSet%_dummy(PClevels)=yes;

);
*--------------------------------------------------------------------------------
$if not defined P_%CheckSet%_Parents alias(P_%CheckSet%_Parents,%CheckSet%_Parents);
%PCset%_Parents(PClevels,%CheckSet%_Parents,P_%CheckSet%_Parents)=yes$%PCset%(PClevels,%CheckSet%_Parents,P_%CheckSet%_Parents);

$offrecurse
$exit;
*=============================================================================
*? Get all root nodes
$label GetRoot
$if "%2"=="" $goto error
$if "%3"=="" $goto error
%display% "Get Root Elements for %3"

$setlocal  CheckSet %2
$setlocal  PCset    %3
$if not defined P_%CheckSet% alias(%CheckSet%,P_%CheckSet%);
$if not defined %CheckSet%_Root  set %CheckSet%_Root(%CheckSet%);
%CheckSet%_Root(%CheckSet%)=sum(P_%CheckSet%$sameas(P_%CheckSet%,%CheckSet%),%PCset%("level1",P_%CheckSet%,%CheckSet%));
$exit
*=============================================================================
*? Get all elements at a certain level
$label GetLevel
$if "%2"=="" $goto error
$if "%3"=="" $goto error
%display% "Get Elements for level %4 in %3"

$setlocal  CheckSet %2
$setlocal  PCset    %3
$setlocal  Level    %4

$if not defined P_%CheckSet% alias(%CheckSet%,P_%CheckSet%);
$if not defined %CheckSet%_Level%level%  set %CheckSet%_Level%level%(%CheckSet%);
%CheckSet%_Level%Level%(%CheckSet%)=sum(P_%CheckSet%,%PCset%("level%level%",%CheckSet%,P_%CheckSet%));
$exit
*=============================================================================
*? Get number of elements at every PC level
$label GetLevelCount
$setlocal  CheckSet %2
$setlocal  PCset    %3

$if not defined PClevels $include PClevels.gms
option CurLevelCount < %PCset%;

$exit
*=============================================================================
$label GetChildrenWithLevel
*? Get elements that are children (of children) of a given element and are at a certain level
$setlocal  CheckSet %2
$setlocal  PCset    %3
$setlocal  Name     %4
$setlocal  Level    %5

$onrecurse

%GetAllChilds% %CheckSet% %PCset% %Name%
%GetLevel%     %CheckSet% %PCset% %Level%

$if not defined %CheckSet%_%Name%_%Level% set %CheckSet%_%Name%_%Level%(%CheckSet%);
%CheckSet%_%Name%_%Level%(%CheckSet%)=no;
%CheckSet%_%Name%_%Level%(%CheckSet%)$(%CheckSet%_Childs(%CheckSet%) and %CheckSet%_Level%Level%(%CheckSet%))=yes;

$offrecurse
$exit
*=============================================================================
$label GetLevelElement
*? Show the level(s) of a given element
$setlocal  CheckSet %2
$setlocal  PCset    %3
$setlocal  Name     %4

$if not defined  %CheckSet%_%Name% set %CheckSet%_%Name%(PClevels);

option CurLevelCount < %PCset%;

loop(PClevels$(CurLevelCount(PClevels)>0),
%CheckSet%_%Name%(PClevels)=yes$sum(%CheckSet%,%PCset%(PClevels,"%Name%",%CheckSet%));
);


$exit
*=============================================================================
$label DefineSetsandParameters
$setlocal  CheckSet %2
$setlocal  PCset    %3

$if not defined PClevels                  $include PClevels.gms
$if not defined P_%CheckSet%              alias(%CheckSet%,P_%CheckSet%);
$if not defined %CheckSet%_Root           set %CheckSet%_Root(%CheckSet%);
$if not defined %CheckSet%_elements       set %CheckSet%_elements(%CheckSet%);
$if not defined %CheckSet%_dummy          set %CheckSet%_dummy(PClevels);
$if not defined %CheckSet%_ChildLevels    set %CheckSet%_ChildLevels(PClevels,%CheckSet%);
$if not defined %CheckSet%_Parents        set %CheckSet%_Parents(%CheckSet%);
$if not defined %CheckSet%_Childs         set %CheckSet%_Childs(%CheckSet%);
$if not defined %PCset%_Parents           set %PCset%_Parents(PClevels,%CheckSet%,%CheckSet%);
$if not defined %PCset%_Childs            set %PCset%_Childs(PClevels,%CheckSet%,%CheckSet%);
$if not defined %CheckSet%_StartLevel     scalar %CheckSet%_StartLevel
*$if not defined %CheckSet%_Level%level%   set %CheckSet%_Level%level%(%CheckSet%);
*$if not defined %CheckSet%_%Name%         set %CheckSet%_%Name%(PClevels);
*$if not defined %CheckSet%_%Name%_%Level% set %CheckSet%_%Name%_%Level%(%CheckSet%);
$exit
*=============================================================================
$label CreatePC
$setlocal  Filename %2
$setlocal  CheckSet %4
$setlocal  PCset    %3

$Evalglobal TreeNumber %TreeNumber%+1
file out%TreeNumber%/"%FileName%"/;

$if not defined P_%Checkset% Alias(%Checkset%,P_%Checkset%);
loop((reverse_pclevels(pclevels,p_pclevels),%CheckSet%,P_%CheckSet%)$%PCset%(p_pclevels,%CheckSet%,P_%Checkset%),
put out%TreeNumber%, '"'p_pclevels.tl:0'"."'%Checkset%.tl:0'"."'P_%Checkset%.tl:0'"' /
);
Putclose out%TreeNumber%;
$exit
*=============================================================================
$label CreatePCTREE
$setlocal  Filename %2
$setlocal  CheckSet %4
$setlocal  PCset    %3

$Evalglobal TreeNumber %TreeNumber%+1
file out%TreeNumber%/"%FileName%"/;

$if not defined P_%Checkset% Alias(%Checkset%,P_%Checkset%);
loop((reverse_pclevels(pclevels,p_pclevels),%CheckSet%,P_%CheckSet%)$%PCset%(p_pclevels,%CheckSet%,P_%Checkset%),
put out%TreeNumber%, '"'p_pclevels.tl:0'"."'%Checkset%.tl:0'"."'P_%Checkset%.tl:0'"' /
);
Putclose out%TreeNumber%;

execute '=elementtree.exe "%FileName%" /delete /save /quit'
$exit
*=============================================================================
$label error
%display% "These functions need 3 parameters."
$exit
*=============================================================================
$label Initialize
%display% "Reading globals for Aggregate function ..."
$SetGlobal TreeDir                 .\
$SetGlobal DefineSetsandParameters $batinclude %TreeDir%Tree.gms DefineSetsandParameters
$SetGlobal GetChild                $batinclude %TreeDir%Tree.gms GetChild
$SetGlobal GetParent               $batinclude %TreeDir%Tree.gms GetParent
$SetGlobal GetAllChilds            $batinclude %TreeDir%Tree.gms GetAllChilds
$SetGlobal GetAllParents           $batinclude %TreeDir%Tree.gms GetAllParents
$SetGlobal GetRoot                 $batinclude %TreeDir%Tree.gms GetRoot
$SetGlobal GetLevel                $batinclude %TreeDir%Tree.gms GetLevel
$SetGlobal GetLevelCount           $batinclude %TreeDir%Tree.gms GetLevelCount
$SetGlobal GetLevelElement         $batinclude %TreeDir%Tree.gms GetLevelElement
$SetGlobal GetChildrenWithLevel    $batinclude %TreeDir%Tree.gms GetChildrenWithLevel
$SetGlobal Aggregate               $batinclude %TreeDir%PCaggregate.gms
$SetGlobal Full                    $batinclude %TreeDir%TreeOptions DoFull
$SetGlobal Difference              $batinclude %TreeDir%TreeOptions DoDifference
$setglobal DoFull                  yes
$setglobal DoDifference            yes
$if "%display%"==""                $SetGlobal display display
$SetGlobal CreatePC                $batinclude %TreeDir%Tree.gms CreatePC
$SetGlobal CreatePCTREE            $batinclude %TreeDir%Tree.gms CreatePCTREE
$SetGlobal TreeNumber              0

$include %TreeDir%PClevels.gms
$exit
*============================   End Of File   ================================