*=============================================================================
* File      : SignTest.gms
* Author    : Wietse Dol (w.dol@wur.nl)
* Version   : 1.0
* Date      : 14-Nov-10 16:54:24
* Changed   : 05-Jan-11 14:18:07
* Changed by: Wietse Dol (w.dol@wur.nl)
* Remarks   :
$ontext

%DoSignTest% has 6 arguments:
   %Data%        parameter to be checked (including sets/subsets)
   %Tuple%       default: All i.e. checl all elements of %Data%
   %Condition%   StrictlyNegative, Negative, Zero, Positive, StrictlyPositive
   %OutName%     default: %Condition%
   %CorrectName% default: Correct
   %WrongName%   default: Wrong
*- OUTPUT: %OutName%%CorrectName%%Data%      default: %Condition%Correct%Data%
*- OUTPUT: %OutName%%WrongName%%Data%        default: %Condition%Wrong%Data%

%DoUserTest% has 7 arguments:
   %Data%        parameter to be checked (including sets/subsets)
   %Tuple%       default: All i.e. checl all elements of %Data%
   %Correct%     condition to be correct
   %Wrong%       default: Otherwise i.e. everything that is not %Correct%
   %OutName%     default: empty
   %CorrectName% default: Correct
   %WrongName%   default: Wrong
*- OUTPUT: %OutName%%CorrectName%%Data%      default: Correct%Data%
*- OUTPUT: %OutName%%WrongName%%Data%        default: Wrong%Data%

NB when you do not specify an argument the default is taken:
*!   %DoSignTest% needs %Data% and %Condition% and
*!   %DoUserTest% needs %Data% and %Correct%

SignTest.gms uses: DoSinUserTest.gms
$offtext
*=============================================================================
*_ Checks
$if "%1"=="" $exit;
$ifi "%1"=="Initialize" $goto Initialize

$if "%2"=="" $exit;
$if "%3"=="" $exit;

$ifi "%1"=="USER" $goto UserChecks
$goto SignTest
*Code for signtest and usertest
$include "DoSignUserTest.gms"
$exit;
*=============================================================================
$label SignTest
$setlocal MakeError yes
$ifi "%3"=="StrictlyNegative"  $setlocal MakeError
$ifi "%3"=="Negative"          $setlocal MakeError
$ifi "%3"=="Zero"              $setlocal MakeError
$ifi "%3"=="StrictlyPositive"  $setlocal MakeError
$ifi "%3"=="Positive"          $setlocal MakeError
$ifi "%3"=="User"              $setlocal MakeError
$ifi "%MakeError%"=="YES" $goto ShowError
*=============================================================================
*_Declarations
$ifi "%3"=="StrictlyNegative"  $setlocal C1 <0
$ifi "%3"=="Negative"          $setlocal C1 <=0
$ifi "%3"=="Zero"              $setlocal C1 =0
$ifi "%3"=="StrictlyPositive"  $setlocal C1 >0
$ifi "%3"=="Positive"          $setlocal C1 >=0
$ifi "%3"=="User"              $setlocal C1 %7

$ifi "%3"=="StrictlyNegative"  $setlocal C2 >=0
$ifi "%3"=="Negative"          $setlocal C2 >0
$ifi "%3"=="Zero"              $setlocal C2 <>0
$ifi "%3"=="StrictlyPositive"  $setlocal C2 <=0
$ifi "%3"=="Positive"          $setlocal C2 <0
$ifi "%3"=="User"              $setlocal C2 %8

$setlocal Par        %1
$setlocal Tuple      %2
$setlocal Condition  %3
$setlocal Outputname %3
$setlocal After      %Par%
$if not "%4"=="" $setlocal OutPutName    %4
$if "%outputName%"=="-" $setlocal OutPutName %Condition%
$if "%outputName%"=="." $setlocal OutPutName %Condition%
$setlocal C  Correct
$setlocal W  Wrong
$if not "%5"==""     $setlocal C %5
$if not "%6"==""     $setlocal W %6

$setlocal Correct %Outputname%%C%%After%
$setlocal Wrong   %Outputname%%W%%After%
*=============================================================================
*_Calculations:
$onmulti
set %Correct%;
set %Wrong%;
$offmulti

%Rundisplay% "Sign check: %Condition% on: %Par%"
%Rundisplay% "Tuple: %Tuple%"
$if  "%Tuple%"=="."     $setlocal Tuple
$if  "%Tuple%"=="-"     $setlocal Tuple
$ifi "%Tuple%"=="All"   $setlocal Tuple
$if not "%Tuple%"==""   $setlocal Tuple %Tuple% and


$ifthen not "%7"=="" %Rundisplay% "Correct Check: %7"
%Rundisplay% "Wrong Check: %8"
%Correct%=no;
%Correct%$(%Tuple% %7)=yes;
%Wrong%=no;
$if not "%8"=="" %Wrong%$(%Tuple% %8)=yes;
$else
%Correct%=no;
%Correct%$(%Tuple% %Par%%c1%)=yes;
%Wrong%=no;
%Wrong%$(%Tuple% %Par%%c2%)=yes;
$endif

%Rundisplay% "Correct Elements: %Correct%"
%Rundisplay% "Wrong   Elements: %Wrong%"

$ifi "%DoCount%"=="yes" $goto CountDisplay

$exit
*=============================================================================
*!Error
$label ShowError
$abort "You made an error in calling the SignTest!"
$exit

*=============================================================================
$label UserChecks

$setlocal Par          %2
$setlocal Tuple        %3
$setlocal Outputname   UserChecks
$setlocal After        %Par%
$if not "%6"==""        $setlocal OutPutName    %6
$if "%OutputName%"=="-" $setlocal OutPutName
$if "%OutputName%"=="." $setlocal OutPutName
$setlocal C  Correct
$setlocal W  Wrong
$if not "%7"==""       $setlocal C %7
$if not "%8"==""       $setlocal W %8
$setlocal correctcond  %4
$setlocal wrongcond    %5
$ifi "%5"==""          $setlocal wrongcond   not (%4)
$ifi "%5"=="Otherwise" $setlocal wrongcond   not (%4)

$setlocal Correct %Outputname%%C%%After%
$setlocal Wrong   %Outputname%%W%%After%

*_Calculations:
$onmulti
set %Correct%;
set %Wrong%;
$offmulti

%Rundisplay% "User check on   : %Par%"
%Rundisplay% "Tuple           : %Tuple%"
%Rundisplay% "Correct Check   : %correctcond%"
%Rundisplay% "Wrong   Check   : %wrongcond%"

$ifi "%Tuple%"=="All"  $setlocal Tuple
$if "%Tuple%"=="."     $setlocal Tuple
$if "%Tuple%"=="-"     $setlocal Tuple
$if not "%Tuple%"==""  $setlocal Tuple %Tuple% and
%Correct%=no;
%Correct%$(%Tuple% (%correctcond%))=yes;

%Wrong%=no;
%Wrong%$(%Tuple% (%wrongcond%))=yes;

%Rundisplay% "Correct Elements%CorrectCount%: %Correct% "
%Rundisplay% "Wrong   Elements%WrongCount%: %Wrong%"

$ifi "%DoCount%"=="yes" $goto CountDisplay

$exit
*=============================================================================
$label Initialize

%Rundisplay% "Reading globals for SignTest..."
$SetGlobal SignTestDir             .\
$SetGlobal SignTest                $batinclude %SignTestDir%dosignusertest.gms  Sign
$SetGlobal UserTest                $batinclude %SignTestDir%dosignusertest.gms  User
$setglobal Data                    $setglobal x
$setglobal Tuple                   $setglobal xTuple
$setglobal Correct                 $setglobal xCorrect
$setglobal Wrong                   $setglobal xWrong
$setglobal OutName                 $setglobal xOutName
$setglobal Condition               $setglobal xCondition
$setglobal CorrectName             $setglobal xCorrectName
$setglobal WrongName               $setglobal xWrongName
$setglobal xWrong                  Otherwise
$setglobal xTuple                  All
$setglobal xOutName                .
$setglobal DoCount                 yes
$if "%rundisplay%"==""             $SetGlobal rundisplay display

%OutName%     .
%CorrectName% Correct
%WrongName%   Wrong
%Wrong%       Otherwise
%Tuple%       All


$exit
*=============================================================================
$label CountDisplay

$setlocal CorrectCount
$setlocal WrongCount

$iftheni "%DoCount%"=="yes"
$if not declared CorrectCount scalar CorrectCount
option CorrectCount:0
$call "=split.exe %After%"
$include %sysenv.username%_Split.txt
option CorrectCount < %Outputname%%C%%SplitName%

$if not declared WrongCount scalar WrongCount
option WrongCount:0
option WrongCount < %Outputname%%W%%SplitName%
$endif

display "#correct elements: ",CorrectCount
display "#wrong   elements: ",WrongCount
$exit
*============================   End Of File   ================================