*=============================================================================
*!Locked by : Wietse Dol (W.Dol@wur.nl)
*!Lock date : 27-Oct-10 8:51:33
* File      : PCAggregate.gms
* Author    : Wietse Dol (w.dol@wur.nl)
* Version   : 1.0
* Date      : 21-Aug-08 08:12:33
* Changed   : 04-Jan-11 15:46:40
* Changed by: Wietse Dol (w.dol@wur.nl)
* Remarks   :
$ontext

If you do not want to test for "All children are empty" switch CheckEmptyChildren from 1 to 0:

$if not defined CheckEmptyChildren scalar CheckEmptyChildren;
CheckEmptyChildren=0;

$offtext
*=============================================================================
$if defined PClevels $goto Start
$include PClevels.gms
$if "%1"=="" $exit
*=============================================================================
$label Start
$if not defined %1 $goto NameError
$if not defined %3 $goto SetError

%DISPLAY% "Aggregate children to calculate the parent (if not available) for: "%1

$setlocal Digits         5
$setlocal Name           %1
$setlocal PreDomain      %2
$setlocal Classification %3
$setlocal PostDomain     %4
$setlocal Children       Children_%Name%_%Classification%
$setlocal PCset          PC_%Classification%
$setlocal Missing        Missing_%Name%_%Classification%
$if not "%5"==""         $setlocal PCset %5
$setlocal Preface
$setlocal PrefaceTitle
$if not "%6"==""         $setlocal Preface %6
$if not "%6"==""         $setlocal PrefaceTitle "%PCset% - "

$setlocal Aggregated     %Preface%Aggregated_%Name%_%Classification%
$setlocal Difference     %Preface%Difference_%Name%_%Classification%
$setlocal Full           %Preface%Full_%Name%_%Classification%
$if "%DoFull%"==""       $setglobal DoFull yes
$if "%DoDifference%"=="" $setglobal DoDifference yes

$setlocal CheckFunction abs(
$setlocal CheckEnd      )
$if settype %PCset% $setlocal CheckFunction
$if settype %PCset% $setlocal CheckEnd

$if not defined P_%Classification% alias(%Classification%,P_%Classification%);

$if not defined screen file screen / 'con' /;
put screen;
put /;
put 'Reading tree: %Classification%'/;
display 'Reading tree: %Classification%';

*aggregate children to their parent when the parent has no value:
put 'Find which levels are needed...'/;
option CurLevelCount < %PCset%;

put 'Aggregate %name% over the %Classification% tree...'/;
display 'Aggregate %name% over the %Classification% tree...';

%rundisplay% 'Calculate # children for elemensts in %Classification% tree.'
$if not defined %Children% parameter %Children%(%Classification%) "Number of children for variable %NAME% in the %CLASSIFICATION% tree";
%Children%(%Classification%)=0;
*=============================================================================
* CALCULATE THE STARTING POINTS IN THE TREE
*=============================================================================
loop(PClevels$(CurLevelCount(PClevels)>0),
%Children%(%Classification%)=
  %Children%(%Classification%)+sum(P_%Classification%$(%PCset%(PClevels,P_%Classification%,%Classification%) and not sameas(P_%Classification%,%Classification%)),1);
    );
*=============================================================================
* DECLARATION AND INITIALIZATION
*=============================================================================
$if not defined %Missing% parameter %Missing%%PreDomain%%Classification%%PostDomain% 'Missing values (i.e. have children)';
%Missing%%PreDomain%%Classification%%PostDomain%=0;


%rundisplay% 'Calculate aggregates and save in %Aggregated%'
$if not defined %Aggregated% parameter %Aggregated%%PreDomain%%Classification%%PostDomain% '%PrefaceTitle%Aggregated %Name% in the %CLASSIFICATION% tree';
%Aggregated%%PreDomain%%Classification%%PostDomain%=0;

$ifthen not "%DoFull%"=="no"
$if not defined %Full%       parameter %Full%%PreDomain%%Classification%,Aggregatetype%PostDomain% '%PrefaceTitle%Full dataset of %Name% in the %CLASSIFICATION% tree';
%Full%%PreDomain%%Classification%,Aggregatetype%PostDomain%=0;
$endif

%Aggregated%%PreDomain%%Classification%%PostDomain%$(%Children%(%Classification%)=0)=%Name%%PreDomain%%Classification%%PostDomain%;

parameter Done_%Classification%(%Classification%);
*=============================================================================
* LOOPING OVER THE TREE AND AGGREGATING CHILDREN
*=============================================================================
loop(PClevels$(CurLevelCount(PClevels)>0),
put 'PC level: 'PClevels.tl:10:0' with #elements='curlevelcount(PClevels):10:0/;

%Name%%PreDomain%%Classification%%PostDomain%$(%Name%%PreDomain%%Classification%%PostDomain%=0)=
  sum(P_%Classification%$%PCset%(PClevels,P_%Classification%,%Classification%),
         %Name%%PreDomain%P_%Classification%%PostDomain%*%PCset%(PClevels,P_%Classification%,%Classification%)
      );

%Missing%%PreDomain%%Classification%%PostDomain%$(%Name%%PreDomain%%Classification%%PostDomain%=0)=1;

%Aggregated%%PreDomain%%Classification%%PostDomain%$(%Aggregated%%PreDomain%%Classification%%PostDomain%=0)=
   sum(P_%Classification%$%PCset%(PClevels,P_%Classification%,%Classification%),
         %Aggregated%%PreDomain%P_%Classification%%PostDomain%*%PCset%(PClevels,P_%Classification%,%Classification%)
      );

if(CheckEmptyChildren,
*if aggregated value is zero (i.e all children are zero) and original data has a value, do not aggregate the children
Done_%Classification%(%Classification%)=0;
Done_%Classification%(%Classification%)=sum(P_%Classification%,%CheckFunction%%PCset%(PClevels,P_%Classification%,%Classification%%CheckEnd%));

%Aggregated%%PreDomain%%Classification%%PostDomain%$
  (
  Done_%Classification%(%Classification%)                 and
  %Aggregated%%PreDomain%%Classification%%PostDomain% = 0 and
  %Name%%PreDomain%%Classification%%PostDomain%
  )
= %Name%%PreDomain%%Classification%%PostDomain%;
)
);
*=============================================================================
* CALCULATIONS
*=============================================================================
$iftheni not "%DoDifference%"=="no"
$if not defined %Difference% parameter %Difference%%PreDomain%%Classification%,AggregateType%PostDomain% '%PrefaceTitle%Differences between %Name% and %Difference%';
%Difference%%PreDomain%%Classification%,AggregateType%PostDomain%=0;

%Difference%%Predomain%%Classification%,"Difference"%postdomain%=
  %Name%%PreDomain%%Classification%%PostDomain%-%Aggregated%%PreDomain%%Classification%%PostDomain%;

*Rounding off values at  digits!
%Difference%%Predomain%%Classification%,"Difference"%postdomain%$(abs(%Difference%%Predomain%%Classification%,"Difference"%postdomain%)<=9*10**(-%digits%))=0;
%Difference%%Predomain%%Classification%,"Missing"%postdomain%$%Missing%%PreDomain%%Classification%%PostDomain%=%Name%%PreDomain%%Classification%%PostDomain%;
%Difference%%Predomain%%Classification%,"Original"%postdomain%$%Difference%%Predomain%%Classification%,"Difference"%postdomain%=%Name%%PreDomain%%Classification%%PostDomain%;
%Difference%%Predomain%%Classification%,"Aggregated"%postdomain%$%Difference%%Predomain%%Classification%,"Difference"%postdomain%=%Aggregated%%PreDomain%%Classification%%PostDomain%;
$endif

$iftheni not "%DoFull%"=="no"
%Full%%Predomain%%Classification%,"Difference"%postdomain%=%Difference%%Predomain%%Classification%,"Difference"%postdomain%;
%Full%%Predomain%%Classification%,"Missing"%postdomain%$%Missing%%PreDomain%%Classification%%PostDomain% = %Name%%PreDomain%%Classification%%PostDomain%;
%Full%%Predomain%%Classification%,"Original"%postdomain%  = %Name%%PreDomain%%Classification%%PostDomain%;
%Full%%Predomain%%Classification%,"Aggregated"%postdomain%= %Aggregated%%PreDomain%%Classification%%PostDomain%;
$endif

putclose screen;

%rundisplay% "Calculated %Classification% tree aggregate for %1"
%rundisplay% "the results are stored in %Aggregated%%PreDomain%%Classification%%PostDomain%"
$if not "%DoDifference%"=="no" %rundisplay% "the differences are stored in %Difference%%PreDomain%%Classification%,AggregateType%PostDomain%"
$if not "%DoFull%"=="no"       %rundisplay% "the full dataset is stored in %Full%%PreDomain%%Classification%,AggregateType%PostDomain%"

$setglobal DoFull
$setglobal DoDifference

display curlevelcount;
$exit
*=============================================================================
* ERRORS
*=============================================================================
$label NameError
display "Parameter %1 doesn't exist"
$exit

$label SetError
display "Set %3 doesn't exist"
$exit
*============================   End Of File   ================================