*=============================================================================
* File      : GetNuts.gms
* Author    : Wietse Dol (w.dol@wur.nl)
* Version   : 1.0
* Date      : 08-Oct-10 09:32:41
* Changed   : 08-Feb-11 12:05:19
* Changed by: Wietse Dol (W.Dol@wur.nl)
* Remarks   :
$ontext

Examples of available tree functions:

GetChild               Get all children of a given element
GetParent              Get the parent(s) of a given element
GetAllChilds           Get children and its children of a given element
GetAllParents          Get parent and its parents of a given element
GetRoot                Get all root elements
GetLevel               Get all elements at a certain level (i.e. level 1 is equal to GetRoot)
GetLevelCount          Get the number of elements at every level
GetLevelElement        Show the level(s) of a given element
GetChildrenWithLevel   Get elements that are children (of children) of a given element and are at a certain level

Aggregate              Aggregation routine (see own example TreeDemo.gms)

Please also read the explanations in the files Tree.gms and PCaggregate.gms

Note that we write the output to the LST file and that we also have an output
routine %Output% that will write the results to the file output.txt

$offtext
*=============================================================================
*! INITIALIZATION
*=============================================================================
*_ Gtree control statements
*! <%GTREECONTROL CLOSEWLOG%>
*! <%GTREECONTROL JUMPLIST "@filenamenoext@.lst",0,0,"","GAMS LST file" %>
*! <%GTREECONTROL JUMPLIST "ElementTree.exe",0,0,"@pathname@nuts.tree","GAMS tree editor for NUTS regions" %>
*! <%GTREECONTROL JUMPLIST "output.txt",0,0,"","GetNuts output file"%>
*! <%GTREECONTROL OPENLSTAFTERCOMPILE%>

*Progress display
$setGlobal WLOG no
*switch to yes if you want to use wlog
*switch to no  if you do not want to use wlog

*_ The commands
$include settings.gms

*_Used to create nice output file for Tree example
$include out.gms
$setGlobal Output $batinclude out.gms
file out/Output.txt/;

*_ Load the data SET and TREE
$include getdata.gms

*=============================================================================
*!Examples for tree operations
*=============================================================================
$ontext
--| NL000000         NEDERLAND
   --| NL100000      NOORD-NEDERLAND
     --| NL110000    Groningen
     --| NL120000    Friesland (NL)
     --| NL130000    Drenthe
   --| NL200000      OOST-NEDERLAND
     --| NL210000    Overijssel
     --| NL220000    Gelderland
     --| NL230000    Flevoland
   --| NL300000      WEST-NEDERLAND
     --| NL310000    Utrecht
     --| NL320000    Noord-Holland
     --| NL330000    Zuid-Holland
     --| NL340000    Zeeland
   --| NL400000      ZUID-NEDERLAND
     --| NL410000    Noord-Brabant
     --| NL420000    Limburg (NL)
   --| NLZ00000      EXTRA-REGIO
     --| NLZZ0000    Extra-Regio
$offtext

* 1 =============================================================================
*- Get all children of Country Netherlands (NL000000)
%GetChild%  NUTS PC_NUTS NL000000
display "Example 1: Get all children of Country Netherlands (NL000000)",NUTS_Childs,"==============================================================================";
%Output% "Example 1: Get all children of Country Netherlands (NL000000)" NUTS_Childs NUTS Classification

* 2 =============================================================================
*- Get parent for Groningen (NL110000)
%GetParent% NUTS PC_NUTS NL110000
display "Example 2: Get parent for Groningen (NL110000)",NUTS_Parents,"==============================================================================";
%Output% "Example 2: Get parent for Groningen (NL110000)" NUTS_Parents NUTS Classification

* 3 =============================================================================
*- Get all Children and their children for Netherlands (NL000000)
%GetAllChilds%  NUTS PC_NUTS "NL000000"

display "Example 3: Get all Children and their children for Netherlands (NL000000)",NUTS_Childs;
display "Example 3: Get all Children and their children and levels for Netherlands (NL000000)",NUTS_ChildLevels,"==============================================================================";
%Output% "Example 3: Get all Children and their children for Netherlands (NL000000)" NUTS_Childs NUTS Classification
%Output% "Example 3: Get all Children and their children and levels for Netherlands (NL000000)" NUTS_ChildLevels NUTS Levels

* 4 =============================================================================
*- Get parent and their parents for Groningen (NL110000)
%GetAllParents%  NUTS PC_NUTS "NL110000"

display "Example 4: Get parent and their parents for Groningen (NL110000)",NUTS_Parents;
display "Example 4: Get parent and their parents for Groningen (NL110000)",NUTS_ParentLevels,"==============================================================================";
%Output% "Example 4: Get parent and their parents for Groningen (NL110000)" NUTS_Parents NUTS Classification
%Output% "Example 4: Get parent and their parents and levels for Groningen (NL110000)" NUTS_ParentLevels NUTS Levels

* 5 =============================================================================
*- Show all root elements of the NUTS tree
%GetRoot% NUTS PC_NUTS
display "Example 5: Show all root elements of the NUTS tree ",NUTS_root,"==============================================================================";
%Output% "Example 5: Show all root elements of the NUTS tree " NUTS_root NUTS Classification

* 6 =============================================================================
*- Get number of elements at every PC level for the NUTS set
%GetLevelCount% NUTS PC_NUTS
display "Example 6: Get number of elements at every PC level for the NUTS set",CurLevelCount;
display "==============================================================================";
%Output% "Example 6: Get number of elements at every PC level for the NUTS set" CurLevelCount NUTS CurLevelCount

* 7 =============================================================================
*- Get all elements at a certain level:
%GetLevel% NUTS PC_NUTS 1
display "Example 7: Get all elements at a certain level",NUTS_level1,"==============================================================================";
%Output% "Example 7: Get all elements at level 1" NUTS_level1 NUTS Classification

%GetLevel% NUTS PC_NUTS 2
display NUTS_level2;
display "==============================================================================";
%Output% "Example 7: Get all elements at level 2 " NUTS_level2 NUTS Classification

%GetLevel% NUTS PC_NUTS 3
display NUTS_level3,"==============================================================================";
%Output% "Example 7: Get all elements at level 3" NUTS_level3 NUTS Classification

%GetLevel% NUTS PC_NUTS 4
display NUTS_level4,"==============================================================================";
%Output% "Example 7: Get all elements at level 4 " NUTS_level4 NUTS Classification

* 8 =============================================================================
*- Get all elements that are children of Country Netherlands and have level 2 (NUTS2 regions)
%GetChildrenWithLevel%  NUTS PC_NUTS "NL000000" 2
display "Example 8: Get all elements that are children of Country Netherlands and have level x",NUTS_NL000000_2,"==============================================================================";
%Output% "Example 8: Get all elements that are children of Country Netherlands and have NUTS level 2" NUTS_NL000000_2 NUTS

*- Get all elements that are children of Country Netherlands and have level 3 (NUTS3 regions)
%GetChildrenWithLevel%  NUTS PC_NUTS "NL000000" 3
display NUTS_NL000000_3,"==============================================================================";
%Output% "Example 8: Get all elements that are children of Country Netherlands and have NUTS level 3" NUTS_NL000000_3 NUTS

* 9 =============================================================================
*- Show the level(s) of a given element
%GetLevelElement% NUTS PC_NUTS "NL000000"
display "Example 9: Show the level(s) of a given element  ",NUTS_NL000000,"==============================================================================";
%Output% "Example 9: Show the level(s) of a given element NL000000" NUTS_NL000000 NUTS GetLevelElement

%GetLevelElement% NUTS PC_NUTS "NL100000"
display NUTS_NL100000,"==============================================================================";
%Output% "Example 9: Show the level(s) of a given element NL100000" NUTS_NL100000 NUTS GetLevelElement

%GetLevelElement% NUTS PC_NUTS "NL110000"
display NUTS_NL110000,"==============================================================================";
%Output% "Example 9: Show the level(s) of a given element NL110000" NUTS_NL110000 NUTS GetLevelElement

*============================   End Of File   ================================