*=============================================================================
* File      : transport.gms
* Author    : GSE demo
* Version   : 1.0
* Date      : 25-09-2006 13:38:16
* Changed   : 16-10-2006 11:20:24
* Changed by: Dram 4 Status A
* Remarks   :
$ontext

$offtext
*=============================================================================
$Title  A Transportation Problem (TRNSPORT,SEQ=1)
$ontext
This problem finds a least cost shipping schedule that meets
requirements at markets and supplies at factories.


Dantzig, G B, Chapter 3.3. In Linear Programming and Extensions.
Princeton University Press, Princeton, New Jersey, 1963.

This formulation is described in detail in:
Rosenthal, R E, Chapter 2: A GAMS Tutorial. In GAMS: A User's Guide.
The Scientific Press, Redwood City, California, 1988.

The line numbers will not match those in the book because of these
comments.

$offtext
* <%SET%>
Sets
       i   canning plants   / seattle, san-diego /
       j   markets          / new-york, chicago, topeka / ;
* <%/SET%>

* <%INPUT%>
Parameters
       a(i)  capacity of plant i in cases
         /    seattle     350
              san-diego   600  /;
* <%FORMAT #,###,##0%>
* <%DIMENSION cases%>
* <%/INPUT%>

* <%INPUT%>
Parameters
       b(j)  demand at market j in cases
         /    new-york    325
              chicago     300
              topeka      275  / ;
* <%FORMAT #,###,##0%>
* <%DIMENSION cases%>
* <%/INPUT%>

* <%INPUT%>
Table d(i,j)  distance in thousands of miles
                    new-york       chicago      topeka
      seattle          2.5           1.7          1.8
      san-diego        2.5           1.8          1.4  ;
* <%FORMAT #,###,##0.##%>
* <%DIMENSION miles%>
* <%/INPUT%>

* <%INPUT%>
Scalar f  freight in dollars per case per thousand miles  /290/ ;
* <%FORMAT #,###,##0%>
* <%DIMENSION dollars per case per 1000 miles%>
* <%/INPUT%>

* <%INPUT%>
Table FixedCosts(i,j)  'Fixed costs in thousands of dollars'
                    new-york       chicago      topeka
      seattle          10             10          10
      san-diego        10             10          10;
* <%FORMAT #,###,##0.##%>
* <%DIMENSION thousands of dollars%>
* <%/INPUT%>

Parameter c(i,j)  transport cost in thousands of dollars per case ;
              c(i,j) = f * d(i,j) / 1000 ;

Variables
       x(i,j)  shipment quantities in cases
       z       total transportation costs in thousands of dollars ;

Positive Variable x ;

Equations
       cost        define objective function
       supply(i)   observe supply limit at plant i
       demand(j)   demand at market j ;

  cost ..        z  =e=  sum((i,j), c(i,j)*x(i,j) +FixedCosts(i,j));

  supply(i) ..   sum(j, x(i,j))  =l=  a(i) ;

  demand(j) ..   sum(i, x(i,j))  =g=  b(j) ;

Model transport /all/ ;

Solve transport using lp minimizing z ;

Display x.l, x.m ;


* <%GDXOUTPUT%>
********************************
*** The GDX OUTPUT statement ***
********************************
execute_UNLOAD 'gseOutput.gdx',a,b,c,d,x,z;

* <%OUTPUT FILE gseOutput.gdx%>
* <%SYMBOL%>
*    <%VARIABLE x(i,j) shipment quantities in cases%>
*    <%FORMAT #,###,##0%>
*    <%DIMENSION cases%>
* <%ENDSYMBOL%>
* <%SYMBOL%>
*    <%VARIABLE z transportation costs in thousands of dollars%>
*    <%FORMAT #,###,##0%>
*    <%DIMENSION thousands of dollars%>
* <%ENDSYMBOL%>
* <%/GDXOUTPUT%>