*<%REGION File header%>
*=============================================================================
* File      : tree.gms
* Author    : Wietse Dol (W.Dol@wur.nl)
* Version   : 1.0
* Date      : 07-Feb-12 07:32:40
* Changed   : 14-Mar-12 13:04:55
* Changed by: Wietse Dol (W.Dol@wur.nl)
* Remarks   :
$ontext

  This file shows examples of the new functionality of Gtree 5.00:
  - To Do items (incl. Todo tab sheet left lower window, see also popup in editor)
  - GTREECOLOR tag: add colors to your code, use popup and "Color picker for text".
  - REGION/ENDREGION tag for code collapsing/expanding.
  - GTREE tags can also being collapsed/expanded.
  - GTREE tags have additional TAG options:
    @EXPANDED         default expand this Gtree tag
    @COLLAPSED        default collapse this Gtree tag
    @NO               this Gtree tag has no expand/collapse fucntionality
    @YES              this Gtree tag has the default expand/collapse fucntionality

    Also use the right mouse click in the editor to see addtional functionality
    for To Do items as well as expand/collaps functionality...

    You can use alt-up arrow or alt-left arrow to collapse a region/gtree tag.
    You can use alt-down arrow or alt-right arrow to expand a region/gtree tag.

    If you add/change text and want to be able to use the expand/collapse
    functionality then either press F6 (rescan current file) or F5 (rescan all files).

    Also added menu item Options-General-Show scan file window.
    If unchecked pressing F5 will show the parsing in the statusbar instead of a seperate window.

    To add more knowledge to you model we have now two new tags:
    - DOCUMENT
    - INFO

    The DOCUMENT tag is used to supply more information on setglobals,sets, parameters, equations,variables.
    The INFO tag (with a category indicator) supplies you with more general information.

    Introduced the "GTREECONTROL PARSE OFF" and "GTREECONTROL PARSE ON"  tag for skipping
    part of your code in a file
$offtext
*=============================================================================
*<%/REGION File header%>
*! <%GTREE 1 Collapse/Expand example 1%>
display 'Gtree control statements...';
*!<%GTREECONTROL IGNORE IGNORE,REGIONEXPAND,REGIONCOLLAPSE,TODO OWNER%>
*!<%GTREECONTROL REGIONEXPAND important%>
*!<%GTREECONTROL REGIONCOLLAPSE part%>
*!<%GTREECONTROL TODO OWNER QBGM test.txt%>

*! ---<%GTREE 1.1 Section 1.1%>
display 'code 1.1...';
display 'code ...';
*! ---<%GTREE 1.2 Section 1.2%>
display 'code 1.2...' ;
*! <%GTREE 2 Collapse/Expand example 2@EXPANDED%>
*! ---<%GTREE 2.1 Section 2.1: Todo tag@COLLAPSED%>
display 'code 2.1...' ;
*!    ---<%GTREE 2.1.1 Subsection 2.1.1@NO%>
display 'code 2.1.1...' ;

*!    ---<%GTREE 2.1.2 Subsection 2.1.2@NO%>
display 'code 2.1.2...' ;
*<%DONE  4 -oWietse Dol (W.Dol@wur.nl) -ccool:important that we do that%>
*! ---<%GTREE 2.2 Section 2.2@NO%>
*! <%GTREE 3 Info and Document tag Example@YES%>
display 'code ...' ;
$ontext
<%DOCUMENT @SelectedYear@ %>
The SelectedYear global is used to specify which data is used in the model.<br>
<IMG SRC="Lion.gif" ALT="Gtree Lion">
<%/DOCUMENT%>
<%DOCUMENT:NL @SelectedYear@ %>
De SelectedYear global geeft aan welk jaar er gekozen is voor het model.
<%/DOCUMENT%>
$offtext
$setglobal SelectedYear 2000

*<%TODO  1 -oWietse Dol -ctest case:We need to do someting%>

$ontext
<%INFO What does this method: xxxx@2 Alert%>
This method <font color=#0000FF>xxxx</font> is used to show the color
output of Gtree 5.00.
<%/INFO%>
<%INFO What does this method: yyyy@1 Warning%>
This method <font color=#00FF00>yyyy</font> is used to show the color
output of Gtree 5.00.
<%/INFO%>
<%INFO What does this method: yy11@1 Warning@2 Important%>
This method <font color=#00FF00>yy11</font> is used to show the color
output of Gtree 5.00.
<%/INFO%>
<%INFO What does this method: yy22@1 Warning@1 Less Important%>
This method <font color=#00FF00>yy2</font> is used to show the color
output of Gtree 5.00.
<%/INFO%>
<%INFO What does this method: zzzz%>
This method <font color=#FF0000>zzzz</font> is used to show the color
output of Gtree 5.00.
<%/INFO%>
<%INFO Hfst10@10 Chapter%>
Information on Chapter 10
<%/INFO%>
<%INFO Hfst1@1 Chapter%>
Information on chapter 1...
<%/INFO%>
<%INFO Hfst2@2 Chapter%>
Information on Chapter 2
<%/INFO%>

$offtext

*! <%GTREE 4 GtreeColor tag Example%>
$ontext
*<%GTREECOLOR #FF8080 #000000%>
xxxx
xxxx
xxxx
*<%GTREEENDCOLOR%>

*<%GTREECOLOR #00FF00 #000000%>
yyyy
yyyy
yyy
*<%GTREEENDCOLOR%>

*<%GTREECOLOR #FFFF00 #000000%>
zzzz
zzzz
zzzz
*<%GTREEENDCOLOR%>

*<%GTREECOLOR #FF8040 #000000%>
aaaaa
aaaaa
aaaaa
*<%GTREEENDCOLOR%>

*<%GTREECOLOR #408080 #000000%>
bbbb
bbb
bbbb
*<%GTREEENDCOLOR%>
$offtext
*! <%GTREE 5 Region tag Example%>

*<%REGION%>
$ontext
<%DOCUMENT country%>
We define countries using the 2 digit ISO country classification
also used by <b>FAO</b> and <font color=#FF0000>Eurostat.</font>
<%/DOCUMENT%>
$offtext
Set Country "EU Countries"
/
  NL  "The Netherlands"
  BE  "Belgium"
  DE  "Germany incl. DDR"
  LUX "Luxembourg"
  IT  "Italy"
  UK  "United Kingdom"
  DK  "Danmark"
/;
*<%/REGION%>
*<%REGION important%>

Set BeNeLux(Country) "Belgium Netherlands Luxembourg" /BE,NL,LUX/;

Set Year/1999*2008/;
*<%REGION part%>
Set Product
/
 Tomato
 Wheat
 Sugar
 Meat
 Corn
 Cotton
/;

Set Capital
/
Land
Labor
/;
*<%/REGION part%>
Parameter Production(Product,Country,Year) "Agricultural Production";
Production(Product,Country,Year)=100*ord(Year)+10*ord(Country)+1*ord(Product);
display Production;

Parameter Price(Product)
/
  Corn   109
  Wheat   90
  Cotton 115
/;

Parameter CapitalUse(Product,Capital)
/
  Corn.Land  1, Wheat.Land  1, Cotton.Land  1,
  Corn.Labor 6, Wheat.Labor 4, Cotton.Labor 8
/;

Parameter MaxCapital(Capital)
/
Land  100
Labor 500
/;

VARIABLES             Income;
POSITIVE VARIABLES    Production(Product);

EQUATIONS     ObjectiveFunction, CapitalRestriction(Capital);

ObjectiveFunction..  Income =E= sum(Product,Price(Product)*Production(Product));

CapitalRestriction(Capital)..
   Sum(Product,CapitalUse(Product,Capital)*Production(Product)) =L= MaxCapital(Capital);

MODEL farmPROBLEM /ALL/;

SOLVE farmPROBLEM USING LP MAXIMIZING Income;

*<%/REGION important%>



*! <%GTREE 6 Parse off and on example%>
*!<%GTREECONTROL PARSE OFF%>
$ontext
<%INFO blanko%>
Wordt nu niet gelezen door GTREE en komt niet in de reference tree en niet in het html rapport
<%/INFO%>
$offtext

$set SecretControlVariable "invisible in GTREE"

*! Geen probleem met moeilijk interpreteerbaare code
$onecho > awk.opt
$0 {if(NF!=1) {print "$setglobal UserName " $NF > "tmp.tmp"}}
$offecho
$include demo2.gms
*!<%GTREECONTROL PARSE ON%>
$include xxdemo.gms
*! <%GTREE 7 Region examples%>
$ontext
<%REGION @expanded%>
demo
<%REGION @collapsed%>
demo 1
<%/REGION%>
demo 2
<%/REGION%>
$offtext
*============================   End Of File   ================================